// DiskDrive.h: interface for the CDiskDrive class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISKDRIVE_H__21765B6D_6C44_4AA4_BCC1_CB140F0E0911__INCLUDED_)
#define AFX_DISKDRIVE_H__21765B6D_6C44_4AA4_BCC1_CB140F0E0911__INCLUDED_

#include "diskimagedos.h"
#include "diskimagepo.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//#define RAW_TRACK_BYTES 6392

#define DDS_MOTORON			( 1 << 0 )
#define DDS_WRITEMODE		( 1 << 1 )

// read cycle per 1 nibble data
// 1024000 / ( 32 * 6400 ) = 5 rps = 300 rpm
#define READ_CLOCK		32

class CDiskDrive
{
public:
	CDiskDrive();
	virtual ~CDiskDrive();

	BYTE	ReadWrite( WORD addr, BYTE data );
	void	Umount();
	BOOL	Mount(const char* pszImageName);
	void	Reset();
	BOOL	IsWriteProtected();
	BYTE	ToggleMotor(WORD addr);

	BYTE	WriteNibble(BYTE data);
	BYTE	ReadNibble();

// attributes
protected:
	void AdjustSpeed();

	int		m_iPosition;
	int		m_iPhysicalTrackNo;

	DWORD	m_dwLastAppleClock;
	WORD	m_wDiskStatus;

	CDiskImage*	m_pDiskImage;

public:
	BOOL IsWriteMode();
	void SetStepper(BYTE byStepperStatus);
	BOOL m_bEnhanced;
	BOOL m_bReadFlag;
	LPCTSTR GetFileName();
};

#endif // !defined(AFX_DISKDRIVE_H__21765B6D_6C44_4AA4_BCC1_CB140F0E0911__INCLUDED_)
