// Cpu.cpp: implementation of the CCpu class.
//
//////////////////////////////////////////////////////////////////////

#include "arch/frame/stdafx.h"
#include "cpu.h"

extern DWORD g_localClock;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CCpu::CCpu()
{
	m_nSpeed = 1;
	m_uException_Register = 0;
	m_nClock = 0;
}

CCpu::~CCpu()
{

}

void CCpu::Clock(int nClock)
{
	m_nClock += nClock * m_nSpeed;
	while( m_nClock > 0 )
	{
		Process();
	}
}

void CCpu::Assert_NMI()
{
	m_uException_Register |= SIG_CPU_NMI;
}

void CCpu::Assert_IRQ()
{
	m_uException_Register |= SIG_CPU_IRQ;
}

void CCpu::Reset()
{
	m_uException_Register |= SIG_CPU_RES;
}

void CCpu::Shutdown()
{
	m_uException_Register |= SIG_CPU_SHUTDOWN;
}

DWORD CCpu::GetClock()
{
	return ( g_localClock - m_nClock / m_nSpeed );
}

void CCpu::SetSpeed(int nSpeed)
{

	if( nSpeed <= 0 )
		nSpeed = 1;
	m_nClock = m_nClock * nSpeed / m_nSpeed;
	m_nSpeed = nSpeed;
}

DWORD CCpu::GetCpuClock()
{
	return ( g_localClock * m_nSpeed - m_nClock );
}