/*
 * Project Blend: the Blossom of .NET Development
 * Copyright (c) 2007 Project Blend
 * 
 *  ̺귯  ƮԴϴ. Ʈ Ǿ絵ڴ  Ʈ 
 * ǥ GNU  Ϲ   㰡 2.1 Ǵ    Ƿ ؼ,  
 *  ̺귯 ϰų   ֽϴ.
 * 
 *  ̺귯 ϰ     ǰ , Ư 
 * ´ ռ γ Ǹſ        
 *   ʽϴ.  ڼ ׿ ؼ GNU  Ϲ   㰡
 * Ͻñ ٶϴ.
 * 
 * GNU  Ϲ   㰡  ̺귯 Բ ˴ϴ. ,   
 * Ǿִٸ  Ʈ  Ͻñ ٶϴ.
 * 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * Korean Translation Comes from: http://korea.gnu.org/people/chsong/copyleft/lgpl.ko.html
 * */

using System;
using System.Text;
using System.Reflection;
using System.Security.Permissions;
using System.Runtime.InteropServices;

#if DEBUG
#pragma warning disable 618
#endif // DEBUG

namespace Blend.xPlatform.Win32
{
    partial class msvcrt
    {
        public static bool S_ISCHR(int m)
        {
            return (m & _S_IFMT).Equals(_S_IFCHR);
        }

        public static bool S_ISDIR(int m)
        {
            return (m & _S_IFMT).Equals(_S_IFDIR);
        }

        public static bool S_ISFIFO(int m)
        {
            return (m & _S_IFMT).Equals(_S_IFIFO);
        }

        public static bool S_ISREG(int m)
        {
            return (m & _S_IFMT).Equals(_S_IFREG);
        }

        public static int _BLOCK_TYPE(ushort block)
        {
            return (block & 0xFFFF);
        }

        public static int _BLOCK_SUBTYPE(ushort block)
        {
            return (block >> 16 & 0xFFFF);
        }

        public static int @sizeof(Type targetType)
        {
            return Marshal.SizeOf(targetType);
        }

        public static int @sizeof<T>()
        {
            return @sizeof(typeof(T));
        }

        public static IntPtr offsetof(Type targetType, string fieldName)
        {
            return Marshal.OffsetOf(targetType, fieldName);
        }

        public static IntPtr offsetof<T>(string fieldName)
        {
            return offsetof(typeof(T), fieldName);
        }

        public static T __max<T>(T left, T right)
            where T: IComparable
        {
            return (left.CompareTo(right) > 0) ? left : right;
        }

        public static int __max(int left, int right)
        {
            return __max<int>(left, right);
        }

        public static T __min<T>(T left, T right)
            where T: IComparable
        {
            return (left.CompareTo(right) < 0) ? left : right;
        }

        public static int __min(int left, int right)
        {
            return __min<int>(left, right);
        }

        public static T max<T>(T left, T right)
            where T: IComparable
        {
            return (left.CompareTo(right) > 0) ? left : right;
        }

        public static int max(int left, int right)
        {
            return max<int>(left, right);
        }

        public static T min<T>(T left, T right)
            where T: IComparable
        {
            return (left.CompareTo(right) < 0) ? left : right;
        }

        public static int min(int left, int right)
        {
            return min<int>(left, right);
        }

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _ftime(IntPtr timeptr);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fstat(int fd, IntPtr buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _stat(string path, IntPtr buffer);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fstati64(int fd, IntPtr buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _stati64(string path, IntPtr buffer);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fstat64(int fd, IntPtr buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _stat64(string path, IntPtr buffer);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _umask(int pmode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wstat(string path, IntPtr buffer);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wstati64(string path, IntPtr buffer);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wstat64(string path, IntPtr buffer);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _futime(int fd, IntPtr filetime);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _utime(string filename, IntPtr times);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wutime(string filename, IntPtr times);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _cgets(string buffer);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _cgetws(string buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cprintf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cprintf(string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cwprintf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cwprintf(string format);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cputs(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cputws(string str);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cscanf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _cwscanf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getch();

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t _getwch();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getche();

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t _getwche();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _kbhit();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _putch(int c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t _putwch(wchar_t c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ungetch(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t _ungetwch(wint_t c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _inp(ushort port);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern ushort _inpw(ushort port);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _inpd(ushort port);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _outp(ushort port, int databyte);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern ushort _outpw(ushort port, ushort dataword);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern ushort _outpd(ushort port, uint dataword);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtCheckMemory();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtDbgReport(
            int reportType, string filename, int linenumber,
            string moduleName, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtDbgReportW(
            int reportType, string filename, int linenumber,
            string moduleName, string format, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtDumpMemoryLeaks();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtSetBreakAlloc(int @new);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtSetDbgFlag(int @new);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _CrtSetDumpClient(IntPtr dumpClient);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _CrtSetReportMode(int reportType, int reportMode);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int __isascii(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int __iscsym(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int __iscsymf(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int __toascii(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _isctype(int c, int desc);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _tolower(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _toupper(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isalnum(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isalpha(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iscntrl(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isdigit(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isgraph(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int islower(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isprint(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int ispunct(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isspace(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isupper(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isxdigit(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int tolower(int c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int toupper(int c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int is_wctype(wint_t c, wctype_t desc);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int isleadbyte(int c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswalnum(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswalpha(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswascii(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswcntrl(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswctype(wint_t c, wctype_t desc);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswdigit(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswgraph(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswlower(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswprint(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswpunct(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswspace(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswupper(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int iswxdigit(wint_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wchar_t towlower(wchar_t c);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wchar_t towupper(wchar_t c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _chdir(string dirname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wchdir(string dirname);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _chdrive(int drive);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _getcwd(StringBuilder buffer, int maxlen);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wgetcwd(StringBuilder buffer, int maxlen);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _getdcwd(int drive, StringBuilder buffer, int maxlen);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wgetdcwd(int drive, StringBuilder buffer, int maxlen);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getdrive();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _getdrives();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _mkdir(string dirname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wmkdir(string dirname);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _rmdir(string dirname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wrmdir(string dirname);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _getdiskfree(uint drive, IntPtr driveinfo);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern terminate_function set_terminate(terminate_function func);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern unexpected_function set_unexpected(unexpected_function func);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern _se_translator_function _set_se_translator(_se_translator_function func);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void terminate();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void unexpected();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _errno();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _copysign(double x, double y);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _chgsign(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _scalb(double x, int exp);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _logb(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _nextafter(double x, double y);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _finite(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _isnan(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fpclass(double x);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _access(string path, int mode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _waccess(string path, int mode);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _chmod(string filename, int pmode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wchmod(string filename, int pmode);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _chsize(int fd, long size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _close(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _commit(int fd);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _creat(string filename, int pmode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wcreat(string filename, int pmode);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _dup(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _dup2(int fd1, int fd2);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _eof(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern long _filelengthi64(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _filelength(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _findclose(intptr_t handle);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _findfirst(string filespec, IntPtr fileinfo);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wfindfirst(string filespec, IntPtr fileinfo);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _findnext(intptr_t handle, IntPtr fileinfo);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wfindnext(intptr_t handle, IntPtr fileinfo);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _get_osfhandle(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _isatty(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _locking(int fd, int mode, int nbytes);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _lseek(int fd, int offset, int origin);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern long _lseeki64(int fd, long offset, int origin);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _mktemp(string template);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wmktemp(string template);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _open(string filename, int oflag, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wopen(string filename, int oflag, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _open_osfhandle(int osfhandle, int flags);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _pipe(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.SysInt, SizeConst = 2)] int[] pfds,
            uint psize, int textmode);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _read(int fd, IntPtr buffer, uint count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _setmode(int fd, int mode);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _sopen(string filename, int oflag, int shflag, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wsopen(string filename, int oflag, int shflag, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _tell(int fd);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern long _telli64(int fd);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _unlink(string filename);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wunlink(string filename);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _write(int fd, IntPtr buffer, uint count);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int remove(string path);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wremove(string path);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int rename(string oldname, string newname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wrename(string oldname, string newname);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string setlocale(int category, string locale);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wsetlocale(int category, string locale);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__amblksize();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _expand(IntPtr memblock, size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _heapadd(IntPtr memblock, size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _heapchk();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _heapmin();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _heapset(uint fill);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _heapwalk(IntPtr entryinfo);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t _msize(IntPtr memblock);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr calloc(size_t num, size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void free(IntPtr memblock);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr malloc(size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr realloc(IntPtr memblock, size_t newsize);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t _get_sbh_threshold();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _set_sbh_threshold(size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _alloca(size_t size);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double sin(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double cos(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double tan(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double sinh(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double cosh(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double tanh(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double asin(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double acos(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double atan(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double atan2(double y, double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double exp(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double log(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double log10(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double pow(double x, double y);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double sqrt(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double ceil(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double floor(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double fabs(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double ldexp(double x, int exp);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double frexp(double x, ref int expptr);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double modf(double x, ref double intptr);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double fmod(double x, double y);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double hypot(double x, double y);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double j0(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double j1(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double jn(int n, double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double y0(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double y1(double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double yn(int n, double x);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _matherr(IntPtr except);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _cabs(_complex z);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getmbcp();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbalnum(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbalpha(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbgraph(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbkalnum(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbkana(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbkprint(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbkpunct(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbprint(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbpunct(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _setmbcp(int codepage);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbblead(uint c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbbtrail(uint c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbslead(string str, string current);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _ismbstrail(string str, string current);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uintptr_t _beginthread(
            _beginthread_start_routine_t start_address,
            uint stack_size, IntPtr arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uintptr_t _beginthreadex(
            IntPtr security,
            uint stack_size,
            _beginthreadex_start_routine_t start_address,
            IntPtr arglist,
            uint initflag,
            ref IntPtr thrdaddr);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _cwait(IntPtr termstat, intptr_t procHandle, int action);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _endthread();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _endthreadex(uint retval);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execl(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecl(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execle(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecle(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execlp(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexeclp(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execlpe(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexeclpe(string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execv(string cmdname, string[] argv);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecv(string cmdname, string[] argv);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execve(string cmdname, string[] argv, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecve(string cmdname, string[] argv, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execvp(string cmdname, string[] argv);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecvp(string cmdname, string[] argv);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _execvpe(string cmdname, string[] argv, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wexecvpe(string cmdname, string[] argv, string[] envp);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getpid();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnl(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnl(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnle(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnle(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnlp(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnlp(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnlpe(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnlpe(int mode, string cmdname, string arg0, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnv(int mode, string cmdname, string[] args);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnv(int mode, string cmdname, string[] args);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnve(int mode, string cmdname, string[] args, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnve(int mode, string cmdname, string[] args, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnvp(int mode, string cmdname, string[] args);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnvp(int mode, string cmdname, string[] args);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _spawnvpe(int mode, string cmdname, string[] args, string[] envp);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern intptr_t _wspawnvpe(int mode, string cmdname, string[] args, string[] envp);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _c_exit();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _cexit();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _exit(int status);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void abort();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void exit(int status);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int system(string command);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _wsystem(string command);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _lfind(IntPtr key, IntPtr @base, ref uint num, uint width, _compare_routine compare);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _lsearch(IntPtr key, IntPtr @base, ref uint num, uint width, _compare_routine compare);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr bsearch(IntPtr key, IntPtr @base, ref uint num, uint width, _compare_routine compare);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr qsort(IntPtr @base, uint num, uint width, _compare_routine compare);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _setjmp(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.SysUInt, SizeConst = msvcrt._JBLEN)] uint[] env);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void longjmp(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.SysUInt, SizeConst = msvcrt._JBLEN)] uint[] env,
            int value);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern __sighandler_t signal(int sig, __sighandler_t func);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int raise(int sig);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint __threadid();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint __threadhandle();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__iob();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fcloseall();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _fdopen(int fd, string mode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _wfdopen(int fd, string mode);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fgetchar();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _filbuf(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fileno(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _flsbuf(int fd, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _flushall();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fputchar(int c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fputwchar(wchar_t c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _fsopen(string filename, string mode, int shflag);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _wfsopen(string filename, string mode, int shflag);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getmaxstdio();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _getw(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _pclose(IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _popen(string command, string mode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _wpopen(string command, string mode);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _putw(int binint, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _rmtmp();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _setmaxstdio(int newmax);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _snprintf(StringBuilder buffer, size_t count, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _snprintf(StringBuilder buffer, size_t count, string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _snwprintf(StringBuilder buffer, size_t count, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _snwprintf(StringBuilder buffer, size_t count, string format);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _tempnam(string dir, string prefix);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wtempnam(string dir, string prefix);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _vsnprintf(StringBuilder buffer, size_t count, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _vsnprintf(StringBuilder buffer, size_t count, string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _vsnwprintf(StringBuilder buffer, size_t count, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _vsnwprintf(StringBuilder buffer, size_t count, string format);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void clearerr(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fclose(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int feof(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int ferror(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fflush(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fgetc(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t fgetwc(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fgetpos(IntPtr stream, ref fpos_t pos);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string fgets(StringBuilder str, int n, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string fgetws(StringBuilder str, int n, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr fopen(string filename, string mode);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _wfopen(string filename, string mode);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fprintf(IntPtr stream, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fprintf(IntPtr stream, string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fwprintf(IntPtr stream, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fwprintf(IntPtr stream, string format);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fputc(int c, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t fputwc(wchar_t c, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fputs(string str, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fputws(string str, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t fread(IntPtr buffer, size_t size, size_t count, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr freopen(string path, string mode, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _wfreopen(string path, string mode, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fscanf(IntPtr stream, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fwscanf(IntPtr stream, string format, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fseek(IntPtr stream, int offset, int origin);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _fseeki64(IntPtr stream, long offset, int origin);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int fsetpos(IntPtr stream, ref fpos_t pos);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int ftell(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t fwrite(IntPtr buffer, size_t size, size_t count, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int getc(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t getwc(IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int getchar();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t getwchar();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string gets(StringBuilder buffer);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _getws(StringBuilder buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void perror(string @string);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _wperror(string @string);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int printf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int printf(string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int wprintf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int wprintf(string format);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int putc(int c, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t putwc(wchar_t c, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int putchar(int c);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t putwchar(wchar_t c, IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int puts(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _putws(string str);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void rewind(IntPtr stream);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int scanf(string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int wscanf(string format, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void setbuf(IntPtr stream, IntPtr buffer);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int setvbuf(IntPtr stream, IntPtr buffer, int mode, size_t size);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int sprintf(StringBuilder buffer, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int sprintf(StringBuilder buffer, string format);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int swprintf(StringBuilder buffer, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int swprintf(StringBuilder buffer, string format);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int sscanf(string buffer, string format, __arglist);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int swscanf(string buffer, string format, __arglist);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr tmpfile();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string tmpnam(StringBuilder str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wtmpnam(StringBuilder str);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int ungetc(int c, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern wint_t ungetwc(wint_t c, IntPtr stream);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__osver();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__winver();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__winmajor();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__winminor();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__argc();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__argv();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__wargv();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__environ();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__wenviron();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__mb_cur_max();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __doserrno();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr __p__fmode();

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern long _atoi64(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern long _wtoi64(string str);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double _atold(string str);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _beep(uint freq, uint duration);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _ecvt(double value, int count, int[] dec, int[] sign);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _fcvt(double value, int count, int[] dec, int[] sign);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _fullpath(string absPath, string relPath, size_t maxLength);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wfullpath(string absPath, string relPath, size_t maxLength);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _gcvt(double value, int digits, StringBuilder buffer);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _itoa(int value, StringBuilder str, int radix);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _i64toa(long value, StringBuilder str, int radix);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _ui64toa(ulong value, StringBuilder str, int radix);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _itow(int value, StringBuilder str, int radix);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _i64tow(long value, StringBuilder str, int radix);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _ui64tow(ulong value, StringBuilder str, int radix);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _lrotl(uint value, int shift);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _lrotr(uint value, int shift);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _makepath(StringBuilder path, string drive, string dir, string fname, string ext);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _wmakepath(StringBuilder path, string drive, string dir, string fname, string ext);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t _mbstrlen(string str);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern _onexit_t _onexit(_onexit_t function);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _rotl(uint value, int shift);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern uint _rotr(uint value, int shift);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _searchenv(string filename, string varname, StringBuilder pathname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _wsearchenv(string filename, string varname, StringBuilder pathname);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _set_error_mode(int modeval);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _seterrormode(int modeval);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _sleep(uint duration);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _splitpath(string path, StringBuilder drive, StringBuilder dir, StringBuilder fname, StringBuilder ext);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _wsplitpath(string path, StringBuilder drive, StringBuilder dir, StringBuilder fname, StringBuilder ext);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void _swab(IntPtr src, IntPtr dest, int n);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int abs(int n);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int atexit(terminate_function function);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double atof(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern double wtof(string str);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int atoi(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int wtoi(string str);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int atol(string str);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int wtol(string str);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern div_t div(int number, int denom);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern ldiv_t ldiv(int number, int denom);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string getenv(string varname);

        [DllImport(ModuleName, CharSet = CharSet.Unicode, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern string _wgetenv(string varname);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int labs(int n);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern size_t _mbclen(string c);

        [DllImport(ModuleName, CharSet = CharSet.Ansi, ExactSpelling = true)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int mblen(string mbstr, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int rand();

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern void srand(uint seed);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr _memccpy(IntPtr dest, IntPtr src, int c, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int _memicmp(IntPtr buf1, IntPtr buf2, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr memcpy(IntPtr dest, IntPtr src, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr memmove(IntPtr dest, IntPtr src, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr memset(IntPtr dest, int offset, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr memchr(IntPtr buf, int c, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern IntPtr wmemchr(IntPtr buf, int c, size_t count);

        [DllImport(ModuleName)]
        [SecurityPermission(SecurityAction.LinkDemand)]
        public static extern int memcmp(IntPtr buf1, IntPtr buf2);
    }
}

#if DEBUG
#pragma warning restore 618
#endif // DEBUG