/*
 * Project Blend: the Blossom of .NET Development
 * Copyright (c) 2007 Project Blend
 * 
 *  ̺귯  ƮԴϴ. Ʈ Ǿ絵ڴ  Ʈ 
 * ǥ GNU  Ϲ   㰡 2.1 Ǵ    Ƿ ؼ,  
 *  ̺귯 ϰų   ֽϴ.
 * 
 *  ̺귯 ϰ     ǰ , Ư 
 * ´ ռ γ Ǹſ        
 *   ʽϴ.  ڼ ׿ ؼ GNU  Ϲ   㰡
 * Ͻñ ٶϴ.
 * 
 * GNU  Ϲ   㰡  ̺귯 Բ ˴ϴ. ,   
 * Ǿִٸ  Ʈ  Ͻñ ٶϴ.
 * 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * Korean Translation Comes from: http://korea.gnu.org/people/chsong/copyleft/lgpl.ko.html
 * */

using System;
using System.Runtime.InteropServices;

#if DEBUG
#pragma warning disable 618
#endif // DEBUG

namespace Blend.xPlatform.Win32
{
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _stat : NativeStructureBase
    {
        public _dev_t st_dev;
        public _ino_t st_ino;
        public ushort st_mode;
        public short st_nlink;
        public short st_uid;
        public short st_gid;
        public _dev_t st_rdev;
        public _off_t st_size;
        public time_t st_atime;
        public time_t st_mtime;
        public time_t st_ctime;

        public static implicit operator _stat(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_stat>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class stat : NativeStructureBase
    {
        public _dev_t st_dev;
        public _ino_t st_ino;
        public ushort st_mode;
        public short st_nlink;
        public short st_uid;
        public short st_gid;
        public _dev_t st_rdev;
        public _off_t st_size;
        public time_t st_atime;
        public time_t st_mtime;
        public time_t st_ctime;

        public static implicit operator stat(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<stat>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _stati64 : NativeStructureBase
    {
        public _dev_t st_dev;
        public _ino_t st_ino;
        public ushort st_mode;
        public short st_nlink;
        public short st_uid;
        public short st_gid;
        public _dev_t st_rdev;
        public __int64 st_size;
        public time_t st_atime;
        public time_t st_mtime;
        public time_t st_ctime;

        public static implicit operator _stati64(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_stati64>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _stat64 : NativeStructureBase
    {
        public _dev_t st_dev;
        public _ino_t st_ino;
        public ushort st_mode;
        public short st_nlink;
        public short st_uid;
        public short st_gid;
        public _dev_t st_rdev;
        public __int64 st_size;
        public __time64_t st_atime;
        public __time64_t st_mtime;
        public __time64_t st_ctime;

        public static implicit operator _stat64(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_stat64>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _timeb : NativeStructureBase
    {
        public time_t time;
        public ushort millitm;
        public short timezone;
        public short dstflag;

        public static implicit operator _timeb(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_timeb>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _utimbuf : NativeStructureBase
    {
        public time_t actime;
        public time_t modtime;

        public static implicit operator _utimbuf(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_utimbuf>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _CrtMemBlockHeader : NativeStructureBase
    {
        [MarshalAs(UnmanagedType.LPStruct)]
        public _CrtMemBlockHeader pBlockHeaderNext;

        [MarshalAs(UnmanagedType.LPStruct)]
        public _CrtMemBlockHeader pBlockHeaderPrev;

        [MarshalAs(UnmanagedType.LPStr)]
        public string szFileName;

        public int nLine;
        public size_t nDataSize;
        public int nBlockUse;
        public int lRequest;

        [MarshalAs(UnmanagedType.LPArray, SizeConst = msvcrt.nNoMansLandSize)]
        public byte[] gap = new byte[msvcrt.nNoMansLandSize];

        public static implicit operator _CrtMemBlockHeader(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_CrtMemBlockHeader>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _CrtMemState : NativeStructureBase
    {
        [MarshalAs(UnmanagedType.LPStruct)]
        public _CrtMemBlockHeader pBlockHeader;

        [MarshalAs(UnmanagedType.LPArray, SizeConst = msvcrt._MAX_BLOCKS)]
        public uint[] lCounts = new uint[msvcrt._MAX_BLOCKS];

        [MarshalAs(UnmanagedType.LPArray, SizeConst = msvcrt.nNoMansLandSize)]
        public uint[] lSizes = new uint[msvcrt._MAX_BLOCKS];

        public uint lHighWaterCount;
        public uint lTotalCount;

        public static implicit operator _CrtMemState(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_CrtMemState>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _diskfree_t : NativeStructureBase
    {
        public uint total_clusters;
        public uint avail_clusters;
        public uint sectors_per_cluster;
        public uint bytes_per_sector;

        public static implicit operator _diskfree_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_diskfree_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public class _finddata_t : NativeStructureBase
    {
        public uint attrib;
        public time_t time_create;
        public time_t time_access;
        public time_t time_write;
        public _fsize_t size;

        [MarshalAs(UnmanagedType.LPStr, SizeConst = 260)]
        public string name;

        public static implicit operator _finddata_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_finddata_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public class _finddatai64_t : NativeStructureBase
    {
        public uint attrib;
        public time_t time_create;
        public time_t time_access;
        public time_t time_write;
        public long size;

        [MarshalAs(UnmanagedType.LPStr, SizeConst = 260)]
        public string name;

        public static implicit operator _finddatai64_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_finddatai64_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public class _wfinddata_t : NativeStructureBase
    {
        public uint attrib;
        public time_t time_create;
        public time_t time_access;
        public time_t time_write;
        public _fsize_t size;

        [MarshalAs(UnmanagedType.LPWStr, SizeConst = 260)]
        public string name;

        public static implicit operator _wfinddata_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_wfinddata_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public class _wfinddatai64_t : NativeStructureBase
    {
        public uint attrib;
        public time_t time_create;
        public time_t time_access;
        public time_t time_write;
        public long size;

        [MarshalAs(UnmanagedType.LPWStr, SizeConst = 260)]
        public string name;

        public static implicit operator _wfinddatai64_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_wfinddatai64_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public class lconv : NativeStructureBase
    {
        public string decimal_point;
        public string thousands_sep;
        public string grouping;
        public string int_curr_sybmol;
        public string currency_symbol;
        public string mon_decimal_point;
        public string mon_thousands_sep;
        public string mon_grouping;
        public string positive_sign;
        public string negatvie_sign;
        public byte int_frac_digits;
        public byte frac_digits;
        public byte p_cs_precedes;
        public byte p_sep_by_space;
        public byte n_cs_precedes;
        public byte n_sep_by_space;
        public byte p_sign_posn;
        public byte n_sign_posn;

        public static implicit operator lconv(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<lconv>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _heapinfo : NativeStructureBase
    {
        public IntPtr _pentry;
        public size_t _size;
        public int _useflag;

        public static implicit operator _heapinfo(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_heapinfo>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _HEAPINFO : NativeStructureBase
    {
        public IntPtr _pentry;
        public size_t _size;
        public int _useflag;

        public static implicit operator _HEAPINFO(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_HEAPINFO>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public class _exception : NativeStructureBase
    {
        public int type;
        public string name;
        public double arg1;
        public double arg2;
        public double retval;

        public static implicit operator _exception(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_exception>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _complex : NativeStructureBase
    {
        public double x;
        public double y;

        public static implicit operator _complex(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_complex>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _JUMP_BUFFER : NativeStructureBase
    {
        public uint Ebp;
        public uint Ebx;
        public uint Edi;
        public uint Esi;
        public uint Esp;
        public uint Eip;
        public uint Registration;
        public uint TryLevel;
        public uint Cookie;
        public uint UnwindFunc;

        [MarshalAs(UnmanagedType.ByValArray, ArraySubType = UnmanagedType.SysUInt, SizeConst = 6)]
        public uint[] UnwindData;

        public static implicit operator _JUMP_BUFFER(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_JUMP_BUFFER>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class _iobuf : NativeStructureBase
    {
        public string _ptr;
        public int _cnt;
        public string _base;
        public int _flag;
        public int _file;
        public int _charbuf;
        public int _bufsiz;
        public string _tmpfname;

        public static implicit operator _iobuf(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<_iobuf>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public class FILE : NativeStructureBase
    {
        public string _ptr;
        public int _cnt;
        public string _base;
        public int _flag;
        public int _file;
        public int _charbuf;
        public int _bufsiz;
        public string _tmpfname;

        public static implicit operator FILE(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<FILE>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class div_t : NativeStructureBase
    {
        public int quot;
        public int rem;

        public static implicit operator div_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<div_t>(ptr);
        }
    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    public class ldiv_t : NativeStructureBase
    {
        public int quot;
        public int rem;

        public static implicit operator ldiv_t(IntPtr ptr)
        {
            return InteropServices.ProduceManagedObject<ldiv_t>(ptr);
        }
    }
}

#if DEBUG
#pragma warning restore 618
#endif // DEBUG